##
## config.py -- Configuration parsing.
##
## Copyleft 1997 Teemu Kalvas <chery@s2.org>
##

## +method cmd_chars
## +method login
## +method realname
## +method want_servers
## +method init          (p)  persistent storage object
## +method do            (p)  persistent storage object

import imp
import os
import pwd
import string
import sys

cmd_chars = '/'
verbose = 0
motd = 1

pw = pwd.getpwuid(os.getuid())
login = pw[0]
realname = pw[4]
f = string.find(realname, ',')
if f <> -1:
    realname = realname[:f]
del pw
del f

if os.environ.has_key('IRCSERVER'):
    server = os.environ['IRCSERVER']
else:
    server = 'irc.pspt.fi'
if os.environ.has_key('IRCPORT'):
    port = os.environ['IRCPORT']
else:
    port = 6667
if os.environ.has_key('IRCNICK'):
    nick = os.environ['IRCNICK']
else:
    nick = login
want_servers = [(server, port, [nick], [])]
del server
del port
del nick

def init(p):
    pass

def do(p):
    pass

def autoop(addr, chan):
    return 0

## Read user's configuration file and transfer entities from it to this
## module's namespace.

userconfpath = os.path.expanduser('~/.clircrc.py')
if os.path.exists(userconfpath):
    userconffile = open(userconfpath, 'r')
    userconf = imp.load_source('userconf', userconfpath, userconffile)
    del userconffile
    config = sys.modules['config']
    for attr in userconf.__dict__.keys():
	if attr[0] <> '_':
	    config.__dict__[attr] = userconf.__dict__[attr]
    del config
    del userconf
del userconfpath

low_table = string.maketrans('ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]',
			     'abcdefghijklmnopqrstuvwxyz{|}')

def low(str):
    return string.translate(str, low_table)

version = 'clirc 0.0.4'

## End. ##
