##
## .clircrc.py for Teemu Kalvas <chery@s2.org>
##

import regex
from types import *

want_servers = [('irc.funet.fi', 6667, ['cliini', '_cliini'],
		 ['#cokers', '#pallomeri', '#tahitibar', '#tampere',
		  '#st'])]

def gen_regex(obj):
    t = type(obj)
    if t == StringType:
	return obj
    elif t == ListType:
	return '\(' + reduce(lambda x, y: x + '\|' + gen_regex(y), obj[1:],
			     gen_regex(obj[0])) + '\)'
    elif t == TupleType:
	return gen_regex(obj[1]) + gen_regex(obj[0])
    else:
	return ''

def do(p):
    global autoop_regex_compiled
    ops = [(':.*', ['.*@tjtk2\.trin\.cam\.ac\.uk',
		   'chery@a31b\.mtalo\.ton\.tut\.fi',
		   'sandra@\(hilavitkutin\.pp\.\)?sci\.fi']),
	   (':#cokers', [('\.tut\.fi',
			  [('\.ton', ['.*@a31b\.mtalo',
				      '.*@a27c\.mtalo',
				      '.*@a29c\.otanner',
				      '.*@k200b\.lanhovi',
				      '.*@h167\.lanhovi',
				      'jonni@a48b\.mtalo',
				      '.?jansu@j184b\.lanhovi']),
			   ('@\(assari\|lehtori\)\.cc', ['pekangas',
							 'hali',
							 'sly',
							 'sunnu']),
			   ('@.*\.cs', ['k153997',
					'sunnu',
					'c142092'])]),
			 '.*@\(.*\.\)vvf\.fi']),
	   (':#tampere', ['annukka@a31b\.mtalo\.ton\.tut\.fi']),
	   (':#st', [('\.sci\.fi', ['.*@\(.*\.\)?one',
				       'nysv@blah\.union',
				       'joonas@\(union\|wopr\)'])])]
    autoop_regex_compiled = regex.compile(gen_regex(ops))

def autoop(addr, chan):
    return autoop_regex_compiled.match(addr + ':' + chan) > 0

## End. ##
