##
## screen.py -- Screen module, curses interface.
##
## Copyleft 1997 Teemu Kalvas <chery@s2.org>
##

## +method clean        ()
## +class Screen        ()
##  -method new_window  (name,
##                       server)
##  -method next        ()
##  -method prev        ()
##  -method touched
##  -method log_area
##  -method stat_area
##  -method edit_area
##  -method current
##  -method stat_line
##  -method edit_field

import curses
import signal

import config
import editfield
import statline
import window

def clean():
    curses.nl()
    curses.noraw()
    curses.endwin()

class Empty:
    name = '(none)'

    def __init__(self):
	self.next = self

class Screen:
    def __init__(self):
	self.window = curses.initscr()
	curses.raw()
	curses.noecho()
	curses.nonl()
	curses.intrflush(1)
	self.window.keypad(1)
	self.touched = 0
	height, width = self.window.getmaxyx()
	self.log_area = self.window.subwin(height - 2, width, 0, 0)
	self.log_area.scrollok(1)
	self.stat_area = self.window.subwin(1, width, height - 2, 0)
	self.edit_area = self.window.subwin(1, width, height - 1, 0)
	self.current = Empty()
	self.stat_line = statline.StatLine(self)
	self.edit_field = editfield.EditField(self)
	signal.signal(signal.SIGWINCH, self.resize)

    def resize(self, a, b):
	self.touched = 64

    def new_window(self, name, server):
	if self.current.__class__ <> Empty:
	    prev = self.current
	    next = prev.next
	    self.current = window.Window(self, next, prev, name, server)
	    prev.next = self.current
	    next.prev = self.current
	else:
	    self.current = window.Window(self, None, None, name, server)
	    self.current.next = self.current
	    self.current.prev = self.current
	self.touched = self.touched | 63
	return self.current

    def next(self):
	if self.current:
	    self.current = self.current.next
	    self.current.detect = 0
	    self.touched = self.touched | 63

    def prev(self):
	if self.current:
	    self.current = self.current.prev
	    self.current.detect = 0
	    self.touched = self.touched | 63

## End, ##
