##
## statline.py -- Status line upkeep.
##
## Copyleft 1997 Teemu Kalvas <chery@s2.org>
##

## +class StatLine  (screen)  parent screen object
##  -method redraw  ()

import curses

class StatLine:
    def __init__(self, screen):
	self.screen = screen
	screen.touched = screen.touched | 16

    def redraw(self):
	window = self.screen.stat_area
	width = window.getmaxyx()[1]
	win = self.screen.current.next
	detect = ''
	while win <> self.screen.current:
	    if not win.detect:
		detect = detect + ' '
	    elif win.detect < 10:
		detect = detect + repr(win.detect)
	    else:
		detect = detect + 'X'
	    win = win.next
	current = self.screen.current
	if current.server.connected:
	    serv_name = current.server.window.name
	else:
	    serv_name = '(' + current.server.window.name + ')'
	if current <> current.server.window:
	    left = current.server.nick + ' on ' + current.name + ' via ' + \
		   serv_name
	else:
	    left = current.server.nick + ' via ' + serv_name
	right = '[' + detect + ']'
	window.insstr(0, 0, left + ' ' + (width - len(left) - len(right) - 2) *
		      '-' + ' ' + right, curses.A_REVERSE)
	self.screen.touched = self.screen.touched | 2

## End. ##
