##
## clirc -- An IRC client in Python.
## config.py - Configuration file reader.
##
## Copyleft 1997-2000 Teemu Kalvas <chery@s2.org>
##

import imp
import os
import pwd
import string
import sys

import idea
import main
import reloadable

cmd_chars = '/'
verbose = 0
motd = 1
emacs_wrap = 0

_pw = pwd.getpwuid(os.getuid())
login = _pw[0]
realname = string.split(_pw[4], ',')[0]

server = os.environ.get('IRCSERVER', 'irc.funet.fi')
port = os.environ.get('IRCPORT', 6667)
nick = os.environ.get('IRCNICK', login)

def autoop(addr, chan):
    return 0

def ignore(addr):
    return 0

gtk = 0
tty = 1
daemon = 0
connect = 0

idea_default_version = 3
default_key = []

_config = sys.modules['config']

if main.init_file:
    _userconfpath = os.path.expanduser(main.init_file)
    if os.path.exists(_userconfpath):
        _userconffile = open(_userconfpath)
        _userconf = imp.load_source('userconf', _userconfpath, _userconffile)
        for _attr in _userconf.__dict__.keys():
            if _attr[0] <> '_':
                _config.__dict__[_attr] = _userconf.__dict__[_attr]

if main.__dict__.has_key('args'):
    for _k, _v in main.args.items():
	_config.__dict__[_k] = _v

_d = locals()
if not _d.has_key('init_nets'):
    init_nets = [('IRCNET', [], [nick, '_' + nick, '__' + nick, '___' + nick],
                  [(server, port)])]

_dk = default_key
default_key = []
known_key = {}
for _k in _dk:
    _fp = idea.key_fingerprint(_k[1], 1)
    if not known_key.has_key(_fp):
	if type(_k[0]) == StringType:
	    _tuple = re.compile(_k[0], re.I), \
		     idea.build_encryption_key(_k[1], 1), \
		     idea.build_encryption_key(_k[1], 2), \
		     idea.build_encryption_key(_k[1], 3)
	    if len(_k) > 2:
		default_key.append(_tuple + (_k[2],))
	    else:
		default_key.append(_tuple)
	else:
	    default_key.append(_k)
	known_key[_fp] = idea.build_decryption_key(_k[1], 1)
	known_key[idea.key_fingerprint(_k[1], 2)] = \
	    idea.build_decryption_key(_k[1], 2)
	known_key[idea.key_fingerprint(_k[1], 3)] = \
            idea.build_decryption_key(_k[1], 3)

## End. ##
