##
## clirc -- An IRC client in Python.
## cursesmodebar.py - Curses status display widget.
##
## Copyleft 1997-2000 Teemu Kalvas <chery@s2.org>
##

import curses
import string
import time

import main
import reloadable
import runloop

statline_left = '%(server:nick)s on %(window:name)s via %(server:name)s'
statline_right = '%(hour)02d:%(minute)02d [%(detect)s]'

class Hashtable(reloadable.Reloadable):
    def __init__(self, screen):
        self.screen = screen

    def __getitem__(self, key):
        def detect_next(win, current, s):
            if win == current:
                return s + '.'
            elif not win.detect:
                return s + ' '
            elif win.detect < 10:
                return s + repr(win.detect)
            else:
                return s + 'X'
        year, month, day, hour, minute, second, weekday, julian, dst = \
              time.localtime(time.time())
        space = None
        i = string.find(key, ':')
        if i:
            space = key[:i]
            key = key[i + 1:]
        h = None
        aw = self.screen.active_window
        if aw:
            if space == 'window':
                h = aw
            elif space == 'server':
                h = aw.buf.net.server
            elif space == 'net':
                h = aw.buf.net
            elif space == 'buffer':
                h = aw.buf
        if h:
            value = getattr(h, key)
        elif key == 'year':
            value = year
        elif key == 'month':
            value = month
        elif key == 'day':
            value = day
        elif key == 'hour':
            value = hour
        elif key == 'minute':
            value = minute
        elif key == 'detect':
            value = ''
            win = self.screen.active_window.next
            while win <> self.screen.active_window:
                value = detect_next(win, self.screen.active_window, value)
                win = win.next
	elif key == 'detect_static':
	    value = ''
	    win = main.buffers[main.nets[0]].log_notify[0]
	    lastwin = win.prev
	    while win <> lastwin:
		value = detect_next(win, self.screen.active_window, value)
		win = win.next
	    value = detect_next(win, self.screen.active_window, value)
        else:
            value = ''
        return value

reloadable.register_for_reload(Hashtable)

class CursesModebar(reloadable.Reloadable, runloop.RepeatingTimer):
    def __init__(self, screen):
	runloop.RepeatingTimer.__init__(self, 60.0, -time.time() % 60)
        self.screen = screen
        self.redraw()
        main.status_changes[self.redraw] = ()

    def run(self):
	self.redraw()

    def window(self):
        return self.screen.get_window(self)

    def changed(self):
        self.screen.window_changed(self)

    def redraw(self):
        self.screen.redraw_window(self)

    def redraw_event(self):
        window = self.window()
        width = self.screen.width
        hash = Hashtable(self.screen)
        left = statline_left % hash + ' ' + width * '-'
        right = ' ' + statline_right % hash
        lr = min(width, len(right))
        line = left[:width - lr] + right[-lr:]
        window.addstr(0, 0, line[:width - 1], curses.A_REVERSE)
        window.insch(0, width - 1, ord(line[width - 1]), curses.A_REVERSE)
        self.changed()

reloadable.register_for_reload(CursesModebar)

## End. ##
