##
## clirc -- An IRC client in Python.
## ircnet.py - IRC network object.
##
## Copyleft 1997-2000 Teemu Kalvas <chery@s2.org>
##

import channel
from event import event
import ircserv
import main
import reloadable
import runloop

class IRCNet(reloadable.Reloadable):
    def __init__(self, id, channel_names, nicks, server_names):
        self.id = id
        self.channel_names = channel_names
        self.nicks = nicks
        self.server_names = server_names
        self.connecting = map(lambda (addr, port), self = self,
                              nicks = nicks: ircserv.IRCServ(
            addr, port, self, nicks), server_names)
        self.server = None
        event.net_init(self)
        main.nets.append(self)
	self.post_reload()

    def post_reload(self):
	self.ensure_defaults([('msg_nicklist', []),
			      ('last_msg_from', ','),
			      ('last_msg_to', '.')])

    def reconnect_init(self):
	self.channel_names = []
	for key in main.buffers.keys():
	    if type(key) == type(()) and key[0] == self:
		self.channel_names.append(key[1])
	self.server = None

    def reconnect(self):
	self.reconnect_init()
	self.connecting = map(
	    lambda (addr, port), self = self, nicks = self.nicks:
	    ircserv.IRCServ(addr, port, self, nicks), self.server_names)

    def reconnect_server(self, (addr, port)):
	self.reconnect_init()
	self.connecting = [ircserv.IRCServ(addr, port, self, self.nicks)]

    def connected(self, serv):
        self.server = serv
        for server in self.connecting:
            if server <> serv:
                server.terminate()
        del self.connecting
	self.server.set_nick()
        self.status_change()

    def status_change(self):
        main.status_change()

    def quit(self, reason):
	## It is possible that self.server is not set, if the server we tried
	## to connect to refused connection or a TCP error occured.
	if self.server:
	    self.server.out_line('QUIT :' + reason)
	    self.server.quitting = 1
        main.nets.remove(self)
	if not main.nets:
	    main.reload = 0
	    runloop.quit = 1

    def delete_buffers(self):
	for key, buf in main.buffers.items():
	    if (type(key) == type(()) and key[0] == self) or key == self:
		buf.pre_delete()
		del main.buffers[key]

reloadable.register_for_reload(IRCNet)

## End. ##
