##
## clirc -- An IRC client in Python.
## main.py - Main program.
##
## Copyleft 1997-2000 Teemu Kalvas <chery@s2.org>
##

import string
import sys
import traceback

version = '0.1.3'

import reloadable
import runloop

args = {}
reload = 1
nets = []
dcc_count = 0
dcc_hash = {}
dcc_pid = {}
dcc_receiving = {}
dcc_sending = {}
init_file = '~/.clircrc.py'
gtk = 0
tty = 1
daemon = 0
connect = 0
screen = None
status_changes = {}
cleaners = {}
in_exception = 0

def status_change():
    for fn in status_changes.keys():
        fn()

def clean():
    for fn in cleaners.keys():
        fn()

def exception_clear():
    global in_exception
    in_exception = 0

def main():
    try:
        main_inner()
    except:
        dump = sys.exc_info()
        clean()
        apply(traceback.print_exception, dump)
        del dump
    else:
        clean()

def main_inner():
    global reload, init_file, screen, in_exception
    global buffers
    i = 1
    while i < len(sys.argv):
        arg = sys.argv[i]
        if arg == '--no-init-file':
            init_file = None
        elif arg == '--init-file':
            init_file = sys.argv[i + 1]
            i = i + 1
        elif arg == '--version':
            print version
            return
        elif arg == '--help':
            print """usage: clirc <option>*
clirc is an extensible IRC client written and extendable in the Python
programming language.  It reads and executes the file ~/.clircrc.py at
startup, unless another startup file is given with the --init-file <file>
command line option, or the --no-init-file option is given, in which case
no initialization code is run.  Other option of interest are:
    --server <server>      set the initial IRC server
    --nick <nick>          set the initial nickname
    --daemon               detaches the program from the controlling
                           terminal and runs in the background
    --tty                  runs as a text mode program (default)
    --gtk                  runs as an X client using the GTK UI library
    --connect              connects to an existing clirc client"""
            return
	elif arg == '--server':
	    args['server'] = sys.argv[i + 1]
	    i = i + 1
	elif arg == '--nick':
	    args['nick'] = sys.argv[i + 1]
	    i = i + 1
	elif arg == '--daemon':
	    args['daemon'] = 1
	elif arg == '--tty':
	    args['tty'] = 2
	elif arg == '--gtk':
	    args['gtk'] = 1
	elif arg == '--connect':
	    args['connect'] = 1
	else:
	    print 'unknown command line option: ' + arg
	    return
        i = i + 1
    import config
    import ircserv
    from event import event
    buffers = ircserv.Hashtable()
    if config.gtk and config.tty == 1:
        config.tty = 0
    if config.daemon:
        import os
        if os.fork():
            if config.tty or config.gtk:
                config.connect = 1
            else:
                return
        os.setsid()
        config.tty = 0
        config.gtk = 0
    if config.tty:
        import cursesscreen
        screen = cursesscreen.CursesScreen()
    if config.gtk:
        import gtkdisplay
        gtkdisplay.GTKDisplay()
    import ircnet
    for id, channel_names, nicks, server_names in config.init_nets:
        ircnet.IRCNet(id, channel_names, nicks, server_names)
    runloop.trailing.append(exception_clear)
    while 1:
        try:
            runloop.run()
        except:
            if in_exception:
                raise
            else:
                in_exception = 1
                for elem in apply(traceback.format_exception, sys.exc_info()):
                    for line in string.split(elem[:-1], '\n'):
                        event.exceptn(line = line)
                continue
        if not reload:
            break
        reloadable.do_reloads()
        reload = 0
        runloop.quit = 0

## End. ##
