##
## clirc -- An IRC client in Python.
## ircnet.py - IRC channel object.
##
## Copyleft 1997-2000 Teemu Kalvas <chery@s2.org>
##

import ircserv
import reloadable

class Channel(reloadable.Reloadable, ircserv.Hashtable):
    def __init__(self):
        ircserv.Hashtable.__init__(self)
	self.modes = {}

    def set_mode(self, ch, *rest):
	if rest:
	    self.modes[ch] = rest[0]
	else:
	    self.modes[ch] = ()

    def unset_mode(self, ch):
	if self.modes.has_key(ch):
	    del self.modes[ch]

reloadable.register_for_reload(Channel)

class Member(reloadable.Reloadable):
    def __init__(self, mode):
        self.mode = mode

    def set_mode(self, mode):
        if not mode in self.mode:
            self.mode = self.mode + mode

    def unset_mode(self, mode):
        self.mode = filter(lambda c, mode = mode: c <> mode, self.mode)

reloadable.register_for_reload(Member)

class Person(reloadable.Reloadable):
    def __init__(self, nick, addr = None):
	self.common = ircserv.Hashtable()
	self.nick = nick
	self.addr = addr

reloadable.register_for_reload(Person)

## End. ##
