##
## clirc -- An IRC client in Python.
## event.py - Event dispatcher switch.
##
## Copyleft 1997-2000 Teemu Kalvas <chery@s2.org>
##

import string

import buffer
import main
import reloadable

import config

class Dispatcher:
    def __getattr__(self, key):
        handler = globals().get(key, None)
        if callable(handler):
            return handler
        else:
            return Handler(handler)

event = Dispatcher()

class Handler(reloadable.Reloadable):
    def __init__(self, handler):
        self.handler = handler

    def __call__(self, *args, **hash):
	if self.handler:
	    for buf in apply(get_buffers, (self.handler[0],), hash):
		buf.log(self.handler[1] % EventHash(hash))

reloadable.register_for_reload(Handler)

class EventHash(reloadable.Reloadable):
    def __init__(self, hash):
        self.hash = hash

    def __getitem__(self, key):
        key_els = string.split(key, ',')
        value = self.hash.get(key_els[0], '')
        key_els = key_els[1:]
        if 'ls' in key_els:
            if value:
                value = ' ' + value
        elif 'rs' in key_els:
            if value:
                value = value + ' '
        return value

reloadable.register_for_reload(EventHash)

def get_buffers(typeid, net = None, chan = None, nick = None, **rest):
    if rest.has_key('addr'):
	if config.ignore(rest['addr']):
	    return []
    if typeid == 'c':
        return [main.buffers[(net, chan)]]
    elif typeid == 'cn':
        bufs = []
        for name, ch in net.server.channels.items():
            if ch.has_key(net.server.people[nick]):
                bufs.append(main.buffers[(net, name)])
        return bufs
    elif typeid == 'n':
        return [main.buffers[net]]
    elif typeid == 'a':
        if main.screen:
            return [main.screen.active_window.buf]
        else:
            return []

def net_init(net = None):
    buf = buffer.Buffer(net, net.id)
    main.buffers[net] = buf
    if main.screen:
        main.screen.add_window(net, net.id, buf)

def own_join(net = None, chan = None):
    if not main.buffers.has_key((net, chan)):
        buf = buffer.Buffer(net, chan)
        main.buffers[(net, chan)] = buf
        main.screen.add_window(net, chan, buf)

invite = 'n', '*** invite to %(chan)s from %(nick)s'
join = 'c', '*** %(nick)s%(modestr,ls)s (%(addr)s) has joined'
kick = 'c', '*** %(nick)s has kicked %(victim)s (%(reason)s)'
mode = 'c', '*** %(nick)s has set mode %(modes)s'
own_mode = 'n', '*** %(nick)s has set mode %(modes)s'
nick = 'cn', '*** %(nick)s is now known as %(nnick)s'
own_nick = None
pong = 'n', '*** server pong: %(time)ss'
quit = 'cn', '*** %(nick)s has quit (%(reason)s)'
topic = 'c', '*** %(nick)s has set topic: %(topic)s'
dcc_send_request = 'n', '*** DCC send request #%(id)d %(filename)s (%(size)s) from %(nick)s'
dcc_receive_start = 'n', '*** DCC receive #%(id)d in progress'
dcc_send_start = 'n', '*** DCC send #%(id)d in progress'
dcc_request_remove = 'n', '*** Pending DCC receive #%(id)d removed'
dcc_receive_remove = 'n', '*** DCC receive #%(id)d removed'
dcc_send_remove = 'n', '*** DCC send #%(id)d removed'
dcc_list = 'n', '*** DCC list:'
dcc_request_list = 'n', '- pending: #%(id)d %(filename)s %(host)s %(port)s %(size)s %(nick)s %(addr)s'
dcc_receive_list = 'n', '- receiving: #%(id)d %(filename)s %(host)s %(port)s %(size)s %(nick)s %(addr)s'
dcc_send_list = 'n', '- sending: #%(id)d %(filename)s %(size)s %(nick)s'
dcc_receive_finish = 'n', '*** DCC receive #%(id)d finished'
dcc_send_finish = 'n', '*** DCC send #%(id)d finished'
status = 'n', '*** %(message)s'
motd = 'n', '*** %(message)s'
status_topic = 'c', '*** topic: %(topic)s'
status_names = 'c', '*** users: %(names)s'
disconnected = 'n', '*** disconnected: %(reason)s'
show_nicklist = 'a', '*** nick list: %(nicklist)s'
exceptn = 'a', '+++ %(line)s'
help_text = 'a', '(help) %(text)s'
error = 'a', '!!! %(error)s'
eval_result = 'a', '=== %(expr)s = %(result)s'
own_version = 'a', '*** %(client)s'
version = 'a', '*** %(nick)s version reply: %(version)s'
unknown = 'a', '*** Unknown: %(command)s %(nick)s %(addr)s %(args)s'

def notice(net = None, nick = None, addr = None, target = None, private = None,
           message = None):
    if config.ignore(addr):
	return
    if not private:
        main.buffers[(net, target)].log(
	    '-' + nick + '- ' + message)
    elif main.buffers.has_key((net, nick)):
        main.buffers[(net, nick)].log('-' + nick + '- ' + message)
    else:
        main.buffers[net].log('-' + nick + '- ' + message)

def own_notice(net = None, target = None, message = None):
    if main.buffers.has_key((net, target)):
        main.buffers[(net, target)].log('-' + net.server.nick + '- ' + message)
    else:
        main.buffers[net].log('-> -' + target + '- ' + message)

def part(net = None, nick = None, addr = None, chan = None, message = None):
    if config.ignore(addr):
	return
    if message == None:
        message = ''
    else:
        message = ' (' + message + ')'
    main.buffers[(net, chan)].log('*** ' + nick + ' has left' + message)

def own_part(net = None, chan = None, message = None):
    main.buffers[(net, chan)].pre_delete()
    del main.buffers[(net, chan)]

def privmsg(net = None, nick = None, addr = None, target = None,
            message = None, crpt = 0, private = None):
    if config.ignore(addr):
	return
    n = crpt + 1
    if main.buffers.has_key((net, target)):
        main.buffers[(net, target)].log(
            n * '<' + nick + n * '>' + ' ' + message)
    elif main.buffers.has_key((net, nick)):
        main.buffers[(net, nick)].log(
            n * '<' + nick + n * '>' + ' ' + message)
    else:
        main.buffers[net].log(
            n * '*' + nick + n * '*' + ' ' + message)

def own_privmsg(net = None, target = None, message = None, crpt = 0):
    n = crpt + 1
    if main.buffers.has_key((net, target)):
        main.buffers[(net, target)].log(
            n * '<' + net.server.nick + n * '>' + ' ' + message)
    else:
        main.buffers[net].log(
            '-> ' + n * '*' + target + n * '*' + ' ' + message)

def ctcp_action(net = None, nick = None, addr = None, target = None,
                message = None):
    if config.ignore(addr):
	return
    if main.buffers.has_key((net, target)):
        main.buffers[(net, target)].log('* ' + nick + ' ' + message)
    elif main.buffers.has_key((net, nick)):
        main.buffers[(net, nick)].log('* ' + nick + ' ' + message)
    else:
        main.buffers[net].log('* ' + nick + ' ' + message)

def own_ctcp_action(net = None, target = None, message = None):
    if main.buffers.has_key((net, target)):
        main.buffers[(net, target)].log('* ' + net.server.nick + ' ' + message)

## End. ##
